#ifndef __CTextIO__
#define __CTextIO__

//	===========================================================================

#include "../Basics/CSystemString.hpp"
#include "../Collections/CollectionTypedef.h"

//	===========================================================================

using Exponent::Collections::TStringCountedPointerArray;
using Exponent::Basics::CSystemString;

//	===========================================================================

namespace Exponent
{
	namespace IO
    {
		/**
		 * @class CTextIO CTextIO.hpp
		 * @brief Quick read and write of text files
		 *
		 * @see CTextStream
		 *
		 * @date 02/10/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CTextIO.hpp,v 1.5 2007/02/08 21:06:44 paul Exp $
		 */
		class CTextIO
		{
		public:

//	===========================================================================

			/**
			 * Read a file
			 * @param path The path to the file to read
			 * @param string On return filled with the entire file as a big array of characters
			 * @param endOfLineCharacter The character to use for the end of lines (either '\\n' or '\\r\\n'
			 * @retval bool True if read correctly, false otherwise
			 */
			static bool readFile(const CSystemString &path, CString &string, const CString &endOfLineCharacter = "\n");

			/**
			 * Read a file and stuff it in to string array
			 * @param path The path to the file to read
			 * @param array On return contains each line of the file as a seperate string
			 * @retval bool True if read properly, false otherwise
			 */
			static bool readFile(const CSystemString &path, TStringCountedPointerArray &array);

			/**
			 * Write a string to the file
			 * @param path The path to the file to write
			 * @param string The stirng to write to the file (can be treated as an array of characters)
			 * @retval bool True if written correctly, false otherwise
			 */
			static bool writeFile(const CSystemString &path, const CString &string);

			/**
			 * Write a string array of lines to file
			 * @param path The path to the file to write
			 * @param array An array containing individual lines to write to the array
			 * @retval bool True if written correctly, false otherwise
			 */
			static bool writeFile(const CSystemString &path, TStringCountedPointerArray &array);

//	===========================================================================

		};
	}
}
#endif	// End of CTextIO.hpp